function peaks = localpeaks(x,mode)
%  Find local peaks and troughs in a vector
%
%   peaks = localpeaks(x,mode)
%
%   This function returns the indices of local peaks and/or
%   troughs in a vector.
%
%   peaks = localpeaks(x) locates the local peaks in vector
%   x.
%
%   peaks = localpeaks(x,mode) locates local features
%   specified by mode, which can be set to 'peaks'
%   (default), 'troughs' in order to identify local troughs,
%   or 'both' in order to identify both local peaks and
%   troughs.

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:01:41 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 71 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

if ~isvector(x)
    error('Input must be a vector')
end

if nargin < 2
    mode = 'peaks';
end

switch lower(mode)
    case 'peaks'
        % do nothing
        peaks = find_peaks(x);
    case 'troughs'
        peaks = find_peaks(-x);
    case 'both'
        peaks = find_peaks(x) | find_peaks(-x);
    otherwise
        error('Unknown localpeak mode. Please specify ''peaks'', ''troughs'' or ''both''');
end

% end of localpeaks()

% ----------------------------------------------------------
% Local functions:
% ----------------------------------------------------------

% ----------------------------------------------------------
% find_peaks: find local peaks in a vector
% ----------------------------------------------------------
function peaks = find_peaks(x)

peaks = false(size(x));
peaks(2:end-1) = sign(x(2:end-1)-x(1:end-2)) + sign(x(2:end-1)-x(3:end)) > 1;

% [EOF]
