function [rev,file] = head_rev(folders,strs)
% Retrieve the head revision for specified files
%
%   [rev,file] = head_rev(folders,strs)
% 
%   This function finds the highest revision present in the
%   working copy of files checked out from a repository.
% 
%   rev = head_rev(folders) returns the head revision (i.e.
%   the highest revision) for all files in folders.
%
%   rev = head_rev(folders,strs) allows additional filter
%   strings strs to be specified. See GET_CONTENTS for
%   details of permitted filter strings.
%
%   [rev,file] = head_rev(...) returns the filename to file
%   of the file with the highest revision.
%
%   Folders and strs may be a string specifying a single
%   occurrence, or a cell array of strings specifying
%   multiple occurrences. This function requires that the
%   'Revision' keyword is used in the searched functions.
% 
%   See also BUILD_SVN_PROFILE, READ_SVN_KEYWORD.

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:01:41 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 71 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

keyword = 'Revision'; % use this data to sort files (doubtful that any others would work, without considerable parsing)

if ischar(folders)
    folders = cellstr(folders);
end

if nargin > 2
    if ischar(strs)
        strs = cellstr(strs);
    end
else
    strs = 'files';
end

% get revision info for files
svn_profile = build_svn_profile(folders,keyword,strs);

% remove the keyword and convert revision strings to numbers
svn_profile(:,3) = cellfun(@(x) str2double(x(length(keyword)+3:end)),svn_profile(:,3),'uni',false);

% remove NaN (files that don't have the revision keyword)
IX1 = cellfun(@isnan,svn_profile(:,3));
svn_profile = svn_profile(~IX1,:);

% sort by revision number
[~,IX2] = sort(cell2mat(svn_profile(:,3)));
svn_profile = svn_profile(IX2,:);

% get highest revision number
rev = svn_profile{end,3};

% return corresponding filename, if requested
if nargout>1
    file = svn_profile{end,1};
end

% [EOF]
