function PI = freq_multi(f)
% Calculate frequency coefficient for ITD-azimuth warping
%
%   PI = freq_multi(f)
%
%   PI = FREQ_MULTI(F) calculates the coefficient PI for
%   frequency F for use in converting between ITD and
%   azimuth in Kuhn's model [1].
% 
%   References
% 
%   [1] Kuhn, G.F. (1977), Model for the interaural time
%   differences in the azimuthal plane, The Journal of the
%   Acoustical Society of America 62, 1, 157-167.
% 
%   See also AZIMUTH2ITD, ITD2AZIMUTH.

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:01:41 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 71 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

if f<=500;
    PI = 3;
elseif f>=3000;
    PI = 2;
else
    PI = 2.5+0.5.*cos(pi.*((log2((sqrt(6)*f)/1250))/(log2(6))));
end

% [EOF]
