function [ccg_azi,sccg] = warp_ccg(ccg,sd,warpers,numchans)
% Warp a CCG to azimuth and skeleton versions
% 
%   [ccg_azi,sccg] = warp_ccg(ccg,sd,warpers,numchans)
% 
% 
%   [ccg_azi,sccg] = warp_ccg(ccg,sd,warpers,numchans) warps
%   the input cross-correlograms (with dims [lag,freq,time]
%   to azimuth-warped and azimuth-warped skeleton
%   cross-correlograms. The azimuth-warping procedure uses
%   the matrix warpers to interpolate the data to the
%   azimuthal domain. It is assumed that size(warpers,2) =
%   numchans and hence that the warping coefficients are
%   kept in the columns of warpers; there should be one
%   coefficient per degree and hence the maximum angle is
%   (size(warpers,1)-1)/2. The skeleton procedure uses
%   standard deviations stored in sd, this can either be a
%   scalar or a vector of length numchans.

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:02:31 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 285 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

check_mex_compiled('-largeArrayDims','warp_ccg_c.c')

if isscalar(sd)
    sd = sd.*ones(numchans,1);
else
    sd = check_input(sd,1,numchans);
end

if ~ismatrix(warpers)
    error('''warpers'' must be a matrix')
else
    warpers = check_input(warpers,2,numchans);
end

[ccg_azi,sccg] = warp_ccg_c(ccg,sd,warpers);


function output = check_input(input,dim,target)

if size(input,dim)~=target
    output = input';
    if size(output,dim)~=target
        error('Input invalid')
    end
else
    output = input;
end

% end of warp_ccg()

% ----------------------------------------------------------
% Local functions:
% ----------------------------------------------------------

% ----------------------------------------------------------
% ismatrix: Check for a matrix
% ----------------------------------------------------------
% check for a matrix
function output = ismatrix(input)

if isnumeric(input)
    output = numel(input) > size(input,1) & numel(input) > size(input,2) & length(size(input)) < 3;
else
    output = false;
end

% [EOF]
