function ccg = prec_macpherson(hc_L,hc_R,env_L,env_R,fs,prec_par_1,prec_par_2,maxlag_d,frame_d,frameCount,numchans,noverlap,room) %#ok<INUSL,INUSD>
% Precedence processing according to Macpherson's model.
% 
%   See also PREC_

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:02:31 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 285 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

% switch room
%     case '0s'
%         prec_par_2 = 1.5;
%     case '0_32s'
%         prec_par_2 = 1.5;
%     case '0_47s';
%         prec_par_2 = 1.5;
%     case '0_68s'
%         prec_par_2 = 1.5;
%     case '0_89s'
%         prec_par_2 = 1.5;
% end

G = prec_par_1;
alpha_m = (prec_par_2/1000)*fs;

lengthCCG = (2.*maxlag_d)+1;
L = round(0.02*fs);
xcorr_window = round(0.001*fs);

% Find local peaks

peaks = cell(numchans,1);
analysis_points = cell(numchans,1);
ccg_peaks = cell(numchans,1);
ccg_inhib = cell(numchans,1);

ccg = zeros(lengthCCG,numchans,frameCount);

win_length = xcorr_window;

for i = 1:numchans
    % Find left peaks
    peaks_L = find(localpeaks(hc_L(i,:)));
    % Find right peaks and points within xcorr_window
    peaks_R = find(localpeaks(hc_R(i,:)));
    peaks_R = unique(peaks_R(ones(2*xcorr_window+1,1),:)+((-xcorr_window:xcorr_window)'*ones(1,length(peaks_R))));
    % remove those at the beginning
    peaks_R = peaks_R(peaks_R>xcorr_window);
    % Find common samples
    peaks_temp = zeros(size(hc_L(i,:)))';
    peaks_temp(peaks_L(ismember(peaks_L,peaks_R))) = peaks_L(ismember(peaks_L,peaks_R));
    % Identify multiple points within xcorr_window
    % Reshape matrix
    peak_length = floor(length(hc_L(i,:))/win_length);
    peaks_temp = reshape(peaks_temp(1:peak_length*win_length),win_length,peak_length);
    % keep points at end of xcorr_window
    peaks_temp = sort(peaks_temp);
    peaks_temp = peaks_temp(end,:);
    peaks_temp = peaks_temp(peaks_temp~=0);
    peaks{i} = peaks_temp;
end

%% Cross-correlograms

inhib = (exp(1)/alpha_m).*(0:L-1).*exp(-(0:L-1)./alpha_m);
inhib(isnan(inhib)) = 0;

inhib_w = max(1-G.*inhib,0);
if sum(inhib_w)~=0
    inhib_w = (1/sum(inhib_w)).*inhib_w;
end

firstFrame = true;
for j = 1:frameCount
    for i = 1:numchans
        % find analysis points within inhibition window
        if firstFrame
            % All the analysis points
            analysis_points{i} = peaks{i}(peaks{i}>=((j-1)*frame_d)+1 & peaks{i}<=(j*frame_d)+L);
        else
            % Only last analysis points
            analysis_points{i} = peaks{i}(peaks{i}>=((j-1)*frame_d)+1+L & peaks{i}<=(j*frame_d)+L);
        end
        inhib_samples = peaks{i}(peaks{i}>=((j-1)*frame_d)+1 & peaks{i}<=(j*frame_d));
        if ~isempty(analysis_points{i})
            append = size(ccg_peaks{i},1);
            % calculate cross-correlation only for the last analysis points
            % (or all, for the first frame only)
            ccg_peaks{i} = [ccg_peaks{i}; zeros(length(analysis_points{i}),lengthCCG)];
            for n = 1:length(analysis_points{i})
                % Calculate cross-correlations at these analysis points
                xcorr_samples = ones(2*xcorr_window+1,1)*max(1-maxlag_d:1+maxlag_d,1)...
                    + (analysis_points{i}(n)-xcorr_window:analysis_points{i}(n)+xcorr_window)'*ones(1,lengthCCG)-1;
                samples_L = sub2ind(size(hc_L),i.*ones(size(xcorr_samples)),xcorr_samples);
                samples_R = sub2ind(size(hc_L),i.*ones(size(xcorr_samples)),fliplr(xcorr_samples));
                ccg_peaks{i}(n+append,:) = mean(hc_L(samples_L).*hc_R(samples_R));
            end
        end
        if ~isempty(inhib_samples)
            ccg_inhib{i} = zeros(length(inhib_samples),lengthCCG);
            points = unique([inhib_samples analysis_points{i}]);
            for n = 1:length(inhib_samples)
                % samples to inhibit
                samples_weight = find(points>=inhib_samples(n) & points<inhib_samples(n)+L);
                % weight with inhibitory function
                ccg_inhib{i}(n,:) = mean(ccg_peaks{i}(samples_weight,:)...
                    .*inhib_w(ones(lengthCCG,1),points(samples_weight)-points(samples_weight(1))+1)');
            end
            ccg(:,i,j) = mean(ccg_inhib{i},1);
        else
            ccg(:,i,j) = 0;
        end
        % remove cross-correlations for current frame
        ccg_peaks{i}(1:length(inhib_samples),:) = [];
    end
    firstFrame = false;
end

% [EOF]
