function output = check_stimuli(filenames,fs)
% Check the user-specified stimuli
% 
%   output = check_stimuli(filenames,fs)
% 
%   output = check_stimuli(filenames,fs) takes a cell array
%   of strings filenames specifying wave file names and
%   performs three checks on the files:
%   - They have the sampling frequency fs, resampling if
%     necessary;
%   - They are mono, mixed to mono if necessary;
%   - They have the same length, zero pads shorter ones if
%     necessary.
% 
%   The wave files are written to a matrix, one column per
%   wave.

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:02:31 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 285 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

if ischar(filenames)
    filenames = cellstr(filenames);
end

wavs = cell(size(filenames));

for n = 1:length(filenames)
    if exist(filenames{n},'file')~=2
        error(['check_stimuli:' filenames{n} 'cannot be found'])
    end
    [wavs{n} wav_fs] = wavread(filenames{n});
    if min(size(wavs{n})) == 2
        disp(['Warning: ' filenames{n} ' is a stereo file and is consequently being mixed to mono...'])
        wavs{n} = wavs{n}.*[0.5; 0.5];
    elseif min(size(wavs)) ~= 1
        error([filenames{n} ' is not a valid stereo or mono audio file'])
    end
    if wav_fs~=fs
        disp(['Resampling ' filenames{n} ' to ' num2str(fs) ' Hz'])
        wavs{n} = resample(wavs{n},fs,wav_fs);
    end
end

length_files = cellfun(@length,wavs);
new_length = max(length_files);

the_wavs = zeros(new_length,length(filenames));

for n = 1:length(filenames)
    the_wavs(1:length(wavs{n}),n) = wavs{n};
end

output = the_wavs;

% [EOF]
