function inhib = calc_inhib(env,alpha,fs)
% Calculate the inhibion signal
% 
%   inhib = calc_inhib(env,alpha,fs)
% 
%   inhib = calc_inhib(env,alpha,fs) calculates the
%   inhibitory signals from the 2-D Hilbert envelopes env
%   (with dimensions [frequency,time]), with the time
%   constant alpha (in ms) and at sampling frequency fs. The
%   matrix returned is the same size as env.

% !---
% ==========================================================
% Last changed:     $Date: 2011-09-13 17:02:31 +0100 (Tue, 13 Sep 2011) $
% Last committed:   $Revision: 285 $
% Last changed by:  $Author: mu31ch $
% ==========================================================
% !---

hlp = (1:fs).*exp((-(1:fs))/((alpha/1000).*fs)); % filter impulse response
if sum(hlp)~=0
    hlp = (1/sum(hlp))*hlp; % normalise to unity gain at DC
end

inhib = zeros(size(env));

for i = 1:size(env,1)
    inhib_temp = conv_fft(env(i,:),hlp);
    inhib(i,:) = inhib_temp(1:size(env,2));
end

% [EOF]
